function testPricePutByHeatEquationExplicit()

sigma = 0.3;
r = 0.05;
K = 110;
S0 = 105;
T = 0.5;
nSds = 8;
M = 50;
N = ceil(2*M^2 / (2*nSds)^2);

[price, W] = pricePutByHeatEquationExplicit( K, T, S0, r, sigma, N, M, nSds );
truePrice = blackScholesPutPrice( K, T, S0, r, sigma );
fprintf('Pricing a put\n');
fprintf('Explicit method price %d\n',price);
fprintf('True price %d\n',truePrice);
assertApproxEqual( price, truePrice, 0.2);

end

