function testPricePutByExplicitMethod()

sigma = 0.3;
r = 0;
K = 110;
S0 = 108;
T = 0.5;
M = 100;
N = 500;
SMax = exp( -(r-0.5*sigma^2)*T + 4 * sigma*sqrt(T))*K;

[price, ~] = pricePutByExplicitMethod( K, T, S0, r, sigma, SMax, N, M );
truePrice = blackScholesPutPrice( K, T, S0, r, sigma );
fprintf('Explicit method price=%d\n',price );
fprintf('Black scholes price=%d\n',truePrice );
assertApproxEqual( price, truePrice, 0.01);

end