function testPriceKnockOutByExplicitMethod()
rng('default')

sigma = 0.3;
r = 0.05;
K = 110;
B = 150;
S0 = 108;
T = 0.5;
M = 150;
N = 10000;


[price, ~] = priceKnockOutByExplicitMethod( K, T, B, S0, r, sigma, N, M );


[mcPrice, mcError]=priceKnockoutByMonteCarlo(...
    K, B, T,...
    S0, r, sigma, ...
    10000, 10000 );

assert( abs(price-mcPrice) < 3*mcError );
end