function testPriceKnockInByExplicitMethod( input_args )

rng('default')

sigma = 0.3;
r = 0.05;
K = 110;
B = 130;
S0 = 108;
T = 0.5;
M = 150;
N = 10000;


[knockOutPrice, ~] = priceKnockOutByExplicitMethod( K, T, B, S0, r, sigma, N, M );
callOptionPrice = blackScholesCallPrice( K, T, S0, r, sigma );
knockInPrice = callOptionPrice - knockOutPrice;
% Main question of pricing the knock in using the explicit method answered

% Now compare with a monte carlo calculation
[mcPrice, mcError]=priceKnockinByMonteCarlo(...
    K, B, T,...
    S0, r, sigma, ...
    10000, 10000 );
assert( abs(knockInPrice-mcPrice) < 3*mcError );

end

