function testPriceAmericanPutByExplicitMethod()

sigma = 0.3;
r = 0.10; % Adding in an interest rate produces decent price differences
K = 105;
S0 = 108;
T = 0.5;
M = 50;
N = 500;

[europeanPrice, ~] = pricePutByExplicitMethod( K, T, S0, r, sigma, 2*S0, N, M );
[americanPrice, ~] = priceAmericanPutByExplicitMethod( K, T, S0, r, sigma, 2*S0, N, M );
disp(americanPrice);
disp(europeanPrice);
bsPrice = blackScholesPutPrice( K, T, S0, r, sigma );
assert( abs(americanPrice - europeanPrice)>0.4);
assert( americanPrice > europeanPrice );
assertApproxEqual( europeanPrice, bsPrice, 0.01);

end
