function [ price, W ] = pricePutByHeatEquationExplicit( K, T, S0, r, sigma, N, M, nSds )
%EULERFORCALL Use the explicit method to price a put option
%   by solving the heat equation in negative time
%   N is the number of time steps
%   M is the number of steps in the x direction
%
%   We make the coordinate changes x=-(r-0.5 sigma^2)t + log S
%                                  W=e^{-rt} V
%   to transform the BS PDE into the heat equation in negative time
assert( rem(M,2)==0); % M must be even

x0 = log( S0 );
% The price is unlikely to move by 8 times the volatility
% so this gives a reasonable range for x.
xMin = x0 - nSds*sqrt(T)*sigma;
xMax = x0 + nSds*sqrt(T)*sigma;

dt = T/N;
dx = (xMax-xMin)/M;

iMin = 1;
iMax = N+1;
jMin = 1;
jMax = M+1;
x = xMin:dx:xMax;
t = 0:dt:T;

W = zeros(N+1,M+1);

lambda = 0.5*sigma^2 * dt/(dx)^2;
disp( lambda );

W(iMax,:)=max(exp(-r*T)*K-exp(-0.5 *sigma^2 * T + x),0);
W(:,jMin)=exp(-r*T)*K- exp(-0.5*sigma^2 * t + x(jMin));
W(:,jMax)=0;

for i=iMax:-1:iMin+1
    W(i-1,jMin+1:jMax-1)=      lambda*W(i,(jMin):(jMax-2)) ...
                        +(1-2*lambda)*W(i,(jMin+1):(jMax-1)) ...
                        +      lambda*W(i,(jMin+2):(jMax));
end    

price = W(iMin,jMin+M/2);

end

