function [ price, V ] = pricePutByExplicitMethod(  K, T, S0, r, sigma, SMax, N, M )
%PRICEPUTBYEXPLICITMETHOD Price a put option by the explicit method
%    using the Black Scholes PDE directly. Note that the only change made
%    is to the boundary conditions.

iMin = 1;
iMax = N+1;
jMin = 1;
jMax = M+1;

dS = SMax/M;
dt = T/N;

t=0:dt:T;
S=0:dS:SMax;

V=zeros(N+1,M+1);
V(iMax,:)=max(K-S,0); % Put option payoff
V(:,jMax)=0; % Estimate for high stock price
V(:,jMin)=exp(-r*(T-t))*K; % Value when stock is zero

for i=iMax:-1:(iMin+1)
    for j=(jMin+1):(jMax-1)
        a = (0.5 * sigma^2 * S(j)^2 * dt)/(dS^2) + r*S(j)*dt/(2*dS);
        b = 1 - sigma^2 * S(j)^2*dt/(dS^2) - r*dt;
        c = (0.5 * sigma^2 * S(j)^2 * dt)/(dS^2) - r*S(j)*dt/(2*dS);
        V(i-1,j) = a*V(i,j+1) + b*V(i,j) + c*V(i,j-1);
    end
end    

% We want to extract the actual price at S0, so use 
% polynomial interpolation since S0 may not fall on a grid point
s0Index = S0/dS+jMin;
price = linearInterpolate(V(iMin,:),s0Index);

end




