function [price, errorEstimate]=priceKnockinByMonteCarlo(...
    strike, barrier, T,...
    S0, r, sigma, ...
    nPaths, nSteps )

% Generate paths in risk neutral measure (mu=r)
priceHistory = generateBSPaths(T,S0,r,sigma,nPaths,nSteps);

knockedIn = max( priceHistory>barrier, [], 2);
finalPrice = priceHistory(:,end);
inMoney = finalPrice>strike;
payoffs = inMoney .* knockedIn .* (finalPrice-strike);

discountedPayoff = exp(-r*T)*payoffs;
price = mean( discountedPayoff );
errorEstimate = std( discountedPayoff )/sqrt(nPaths);

end
