function [ price, V ] = priceKnockOutCallByExplicitMethod(  ...
    K, T, B, S0, r, sigma, N, M )
%PRICEKNOCKOUTBYEXPLICITMETHOD Price a knock out option by the explicit method
%    the barrier is B. Note all that has changed from the call option code
%    is the top boundary condition.

iMin = 1;
iMax = N+1;
jMin = 1;
jMax = M+1;

dS = B/M;
dt = T/N;

t=0:dt:T;
S=0:dS:B;

V=zeros(N+1,M+1);
V(iMax,:)=max(S-K,0); % Call option payoff
V(:,jMax)=0; % Worthless at barrier
V(:,jMin)=0; % Worthless when stock is zero

for i=iMax:-1:(iMin+1)
    for j=(jMin+1):(jMax-1)
        a = (0.5 * sigma^2 * S(j)^2 * dt)/(dS^2) + r*S(j)*dt/(2*dS);
        b = 1 - sigma^2 * S(j)^2*dt/(dS^2) - r*dt;
        c = (0.5 * sigma^2 * S(j)^2 * dt)/(dS^2) - r*S(j)*dt/(2*dS);
        V(i-1,j) = a*V(i,j+1) + b*V(i,j) + c*V(i,j-1);
    end
end    

% We want to extract the actual price at S0, so use 
% polynomial interpolation since S0 may not fall on a grid point
s0Index = S0/dS+jMin;
price = linearInterpolate(V(iMin,:),s0Index);

end


