function plotCurvesForSlides()
% Generate the curves shown in the slides

sigma = 0.3;
r = 0.05;
K = 110;
S0 = 108;
T = 0.5;
M = 20;
N = 40;

[~, V] = priceCallByExplicitMethod( K, T, S0, r, sigma, 2*S0, N, M );

[X, Y] = meshgrid(linspace(0,2*S0,M+1),linspace(0,T,N+1));
mesh(X,Y,V);
xlabel('S');
ylabel('T');
zlabel('V');
axis([0 200 0 0.5 0 120]);
print('surface.eps' );

end

