function plotConvergence()
%CONVERGENCEEXPLICITMETHODCALL Plot the convergence
% to the Black Scholes price of the explicit method
% using the heat equation transform

nSds = 8;
sigma = 0.3;
r = 0.1;
K = 100;
S0 = 108;
T = 0.5;
nPoints = 10;
dt = zeros(1,nPoints);
error = zeros(1,nPoints);
for i=1:10 
    M = 2^i;
    N = ceil(2*M^2 /(2*nSds)^2);
    
    price = priceCallByHeatEquationExplicit( K, T, S0, r, sigma, N, M, nSds );
    truePrice = blackScholesCallPrice( K, T, S0, r, sigma );
    error(i) = abs(price - truePrice);
    dt(i) = T/N;
end
loglog(dt,error);
xlabel('dt');
ylabel('error');
title('Convergence of explicit method');
print('explicitConvergence.eps');

end
