function ret = linearInterpolate( vector, index )
% Find the value at the given index by linear interpolation
if index>=size(vector)
    ret = vector(end);
elseif index<=1
    ret = vector(1);
else     
    lower = floor(index);
    upper = ceil(index);
    lambda = index-lower;
    ret = (1-lambda)*vector(lower) + lambda*vector(upper);
end
end


