function generateSurfacePlot()
% Generate a surface plot to visually illustrate the method
%
% Uses a fairly small grid which is aligned to the strike price
% for visual clarity
sigma = 0.3;
r = 0;
K = 15;
S0 = 10;
T = 0.5;
M = 20;
N = 50;

[~, V] = priceCallByExplicitMethod( K, T, S0, r, sigma, 20, N, M );
figure();
title('Call option price surface');
surf( V );
ylabel('Time');
xlabel('Stock Price');
zlabel('Option Price');

end

