function [ price ] = ...
    blackScholesPutPrice( K, T, S0, r, sigma )
% Computes the price of an option using
% the Black Scholes formula.
% (The parameter order is contract terms
% then market data.)

numerator = log(S0./K) + (r+0.5*sigma.^2).*T;
denominator = sigma.*sqrt(T);
d1 = numerator./denominator;
d2 = d1 - denominator;
price = exp(-r.*T).*K.*normcdf(-d2) - S0 .* normcdf(-d1);

end
