function testSimulateGammaHedging()
%  When delta hedging we expect to break even on average
rng( 'default');

K1 = 110;
K2 = 120;
T = 0.5;
S0 = 100;
sigma = 0.2;
mu = 0.05;
r = 0.05;

nPaths = 1000;
nSteps = 133;
sellTime = 0.4;

[charge,~] = blackScholesCallPrice(K1,T,S0,r,sigma);

fprintf('Charge for call option %d\n', charge);
finalBalances = simulateGammaHedging(charge,K1,K2,T,S0,r,mu,sigma,nPaths,nSteps, sellTime);
fprintf('Mean balance at maturity %d\n', mean( finalBalances));
hist( finalBalances, 20 );
assertApproxEqual( mean(finalBalances)/charge, 0.0, 0.01);

end


