function testSimulateDeltaHedging()
%  When delta hedging we expect to break even on average
rng( 'default');

K = 110;
T = 0.5;
S0 = 100;
sigma = 0.2;
mu = 0.05;
r = 0.03;

nPaths = 5000;
nSteps = 1000;

[charge,~] = blackScholesCallPrice(K,T,S0,r,sigma);

fprintf('Charge for call option %d\n', charge);
finalBalances = simulateDeltaHedging(charge,K,T,S0,r,mu,sigma,nPaths,nSteps);
fprintf('Mean balance at maturity %d\n', mean( finalBalances));
hist( finalBalances, 20 );
title('Distribution of profits when delta hedging daily and charging BS Price');
assertApproxEqual( mean(finalBalances)/charge, 0.0, 0.01);

figure()
finalBalancesZeroCharge = simulateDeltaHedging(0,K,T,S0,r,mu,sigma,nPaths,nSteps);
hist( finalBalancesZeroCharge, 20 );
title('Distribution of profits when delta hedging daily and charging zero');

end

