function testGenerateBSPaths()
%TESTGENERATEBSPATHS Summary of this function goes here
%   Detailed explanation goes here
rng('default'); % ensures same random numbers are generated each time

T = 1.0;
S0 = 100;
sigma = 0.1;
r = log(1.05);

paths = generateBSPaths( T, S0, r, sigma,10000, 1 );
discountedMean = exp(-r*T)*mean( paths );
assertApproxEqual( discountedMean, S0, 0.1);
logProcess = log( paths );
sigmaActual = std( logProcess );
assertApproxEqual( sigmaActual, sigma, 0.01);


end

