function testSimulateDeltaHedging()
%  When delta hedging we expect to break even on average
rng( 'default');

K = 110;
T = 0.5;
S0 = 100;
sigma = 0.2;
mu = 0.05;
r = 0.05;
stopTime = 0.4;

nPaths = 1000;
nSteps = 1000;

[charge,~] = blackScholesCallPrice(K,T,S0,r,sigma);

finalBalances = earlyExitDeltaHedging(charge,K,T,S0,r,mu,sigma,nPaths,nSteps,stopTime);
hist( finalBalances, 20 );
assertApproxEqual( mean(finalBalances)/charge, 0.0, 0.005);

end

