% Suppose we sell a call option to a customer for the cost 
%  chargeToCustomer
% and the option has strike K and maturity T.
% The market is assumed to follow a model with parameters S0, r, mu, sigma
% We delta hedge the at nSteps intervals up to maturity and compute the
% final bank balance.
%
% We run the simulation nPaths times.
function [ finalBankBalance] = simulateDeltaHedging(  chargeToCustomer, K, T, S0, r, mu, sigma, nPaths, nSteps  )

dt = T/nSteps;
times = dt:dt:T;
paths = generateBSPaths( T, S0, mu, sigma, nPaths, nSteps );

[~,delta] = blackScholesCallPrice(K,T,S0,r,sigma);    
stockQuantity = delta;
cost = stockQuantity .* S0;
bankBalance = chargeToCustomer-cost;

for t=1:(nSteps-1)    
    S = paths(:,t);
    timeToMaturity = T-times(t);
    [~,delta] = blackScholesCallPrice(...
        K,timeToMaturity,S,r,sigma);
    newStockQuantity = delta;
    amountToBuy = newStockQuantity - stockQuantity;
    cost = amountToBuy .* S;
    bankBalance = exp(r*dt)*bankBalance - cost;
    
    stockQuantity = newStockQuantity;
end    

S = paths(:,nSteps);
stockValue = stockQuantity .* S;
liability = max(S-K, 0);

bankBalance = exp(r*dt)*bankBalance + stockValue - liability;

finalBankBalance = bankBalance;

end

