function strategyComparisonPlot()
% Plot the error of the delta hedging strategy
% against num time steps

rng( 'default');

K1 = 110;
K2 = 120;
T = 0.5;
S0 = 100;
sigma = 0.2;
mu = 0.05;
r = 0.05;

nPaths = 1000;
sellTime = 0.4;

stepCounts = 2.^(1:14);

[charge,~] = blackScholesCallPrice(K1,T,S0,r,sigma);
deltaRMSError = zeros( length( stepCounts ), 1 );
gammaRMSError = zeros( length( stepCounts ), 1 );
stopLossRMSError = zeros( length( stepCounts ), 1 );
noHedgeRMSError = zeros( length( stepCounts ), 1 );
for i=1:length(stepCounts)
    nSteps = stepCounts(i);
    finalDeltaBalance = simulateEarlyExitHedging( ...
        charge, ...
        K1, T, ...
        S0, r, mu, sigma, ...
        nPaths, nSteps, sellTime, @chooseDeltaHedge);
    deltaRMSError(i) = sqrt( mean(finalDeltaBalance.^2) );
    finalGammaBalance = simulateGammaHedging( ...
        charge, ...
        K1, K2, T, ...
        S0, r, mu, sigma, ...
        nPaths, nSteps, sellTime);
    gammaRMSError(i) = sqrt( mean(finalGammaBalance.^2) );
    finalStopLossBalance = simulateEarlyExitHedging( ...
        charge, ...
        K1, T, ...
        S0, r, mu, sigma, ...
        nPaths, nSteps, sellTime, @chooseStopLossHedge);
    stopLossRMSError(i) = sqrt( mean(finalStopLossBalance.^2) );
    finalNoHedgeBalance = simulateEarlyExitHedging( ...
        charge, ...
        K1, T, ...
        S0, r, mu, sigma, ...
        nPaths, nSteps, sellTime, @chooseNoHedge);    
    noHedgeRMSError(i) = sqrt( mean(finalNoHedgeBalance.^2) );
end 

loglog( stepCounts, deltaRMSError/charge, ...
        stepCounts, gammaRMSError/charge, ...
        stepCounts, stopLossRMSError/charge, ...
        stepCounts, noHedgeRMSError/charge);
title('Relative error of final balance');
xlabel('Number of steps');
ylabel('Relative error');
legend('Delta hedging strategy', 'Gamma hedging strategy', 'Stop loss strategy', 'No hedge');

end


