function plotHedgingErrorTxCosts()
% Plot the error of the delta hedging strategy
% against num time steps

rng( 'default');

K1 = 110;
T = 0.5;
S0 = 100;
sigma = 0.2;
mu = 0.05;
r = 0.03;
epsilon=0.001; %One basis point

nPaths = 1000;

stepSizes = 2.^(1:14);

[charge,~] = blackScholesCallPrice(K1,T,S0,r,sigma);
rmsError = zeros( length( stepSizes ), 1 );
rmsErrorWithTx = zeros( length( stepSizes ), 1 );
for i=1:length(stepSizes)
    nSteps = stepSizes(i);
    finalBalance = simulateDeltaHedgingWithTxCosts( ...
        charge, ...
        K1, T, ...
        S0, r, mu, sigma, ...
        nPaths, nSteps, 0 );
    finalBalanceWithTx = simulateDeltaHedgingWithTxCosts( ...
        charge, ...
        K1, T, ...
        S0, r, mu, sigma, ...
        nPaths, nSteps, epsilon );
    rmsError(i) = sqrt( mean( finalBalance.^2));
    rmsErrorWithTx(i) = sqrt( mean( finalBalanceWithTx.^2));
end 

loglog( stepSizes, rmsError/charge, stepSizes, rmsErrorWithTx/charge );
title('Relative error of final balance');
legend('Without transaction costs', 'With transaction costs');

end


