function plotHedgingError()
% Plot the error of the delta hedging strategy
% against num time steps

rng( 'default');

K1 = 110;
K2 = 120;
T = 0.5;
S0 = 100;
sigma = 0.2;
mu = 0.05;
r = 0.03;

nPaths = 1000;

numbersOfSteps = 2.^(1:13);

[charge,~] = blackScholesCallPrice(K1,T,S0,r,sigma);
rmsError = zeros( length( numbersOfSteps ), 1 );
for i=1:length(numbersOfSteps)
    nSteps = numbersOfSteps(i);
    finalBalance = simulateDeltaHedging( ...
        charge, ...
        K1, T, ...
        S0, r, mu, sigma, ...
        nPaths, nSteps );
    rmsError(i) = sqrt( mean( finalBalance.^2));
end 

loglog( numbersOfSteps, rmsError/charge );
title('Relative error of final balance');
xlabel('Number of steps');
ylabel('Relative Error');

end

