% Suppose we sell a call option to a customer for the cost 
%  chargeToCustomer
% and the option has strike K and maturity T.
% The market is assumed to follow a model with parameters S0, r, mu, sigma
% We delta hedge the at nSteps intervals up to maturity and compute the
% final bank balance.
%
% We run the simulation nPaths times.
function [ marketValue ] = earlyExitDeltaHedging(  chargeToCustomer, K, T, S0, r, mu, sigma, nPaths, nSteps, sellTime  )

dt = sellTime/nSteps;
times = dt:dt:sellTime;
paths = generateBSPaths( sellTime, S0, mu, sigma, nPaths, nSteps );

bankBalance = chargeToCustomer;
[~,delta] = blackScholesCallPrice(K,T,S0,r,sigma);    
stockQuantity = delta;
cost = stockQuantity .* S0;
bankBalance = bankBalance-cost;

for t=1:nSteps
    bankBalance = exp(r*dt)*bankBalance;
    
    S = paths(:,t);
    timeToMaturity = T-times(t);
    [optionPrice,delta] = blackScholesCallPrice(K,timeToMaturity,S,r,sigma);
    newStockQuantity = delta;
    amountToBuy = newStockQuantity - stockQuantity;
    cost = amountToBuy .* S;
    bankBalance = bankBalance - cost;
    
    stockQuantity = newStockQuantity;
    
    marketValue = bankBalance + stockQuantity .* S - optionPrice;   
end    



end

