function indifferencePrice= computeIndifferencePrice( a )
%  Compute the indifference price when the trader uses
%  The delta hedging strategy


K = 110;
T = 0.5;
S0 = 100;
sigma = 0.2;
mu = 0.05;
r = 0.03;

nPaths = 10000;
nSteps = 133;

payoff = simulateDeltaHedging(0,K,T,S0,r,mu,sigma,nPaths,nSteps);

% Define the utility function
function utility=u( x )
    utility = (1-exp(-a.*x))/a;
end    
        
% Write a function that computes the expected utility
% given the price
function ret=expectedUtility( price ) 
    ret = mean( u( exp(r*T)*price + payoff ) );
end    

% Initial guess
[blackScholesPrice,~] = blackScholesCallPrice(K,T,S0,r,sigma);
% Use fsolve to find the solution
indifferencePrice = fsolve( @expectedUtility, blackScholesPrice );
end

