function compute99ProfitPrices()
%Answer the question posed in the lecture

K = 110;
T = 0.5;
S0 = 100;
sigma = 0.2;
mu = 0.05;
r = 0.03;

nPaths = 10000;
nSteps = 133;

noHedgeFinalBalances = simulateHedging(0,K,T,S0,r,mu,sigma,nPaths,nSteps,@chooseNoHedge);
stopLossFinalBalances = simulateHedging(0,K,T,S0,r,mu,sigma,nPaths,nSteps,@chooseStopLossHedge);
deltaFinalBalances = simulateHedging(0,K,T,S0,r,mu,sigma,nPaths,nSteps,@chooseDeltaHedge);

fprintf('Price A=%d\n', -exp(-r*T) * prctile( noHedgeFinalBalances, 1));
fprintf('Price B=%d\n', -exp(-r*T) * prctile( stopLossFinalBalances, 1));
fprintf('Price C=%d\n', -exp(-r*T) * prctile( deltaFinalBalances, 1));

end

