function testPriceKnockoutByMonteCarloAntithetic()
%rng('default'); % ensures same random numbers are generated each time

% If the barrier is very high, this should approximate
% a call option very well
barrier = 1000000;
K = 105;
T = 0.5;
S0 = 100;
r = log(1.05);
sigma = 0.1;
nPaths = 100000;
nSteps = 2;

[price,error] = ...
    priceKnockoutByMonteCarlo( ...
        K, barrier, T, ...
        S0, r, sigma, ...
        2*nPaths, nSteps );
expected = blackScholesCallPrice( K, T, ...
        S0, r, sigma );
assertApproxEqual( price, expected, 2*error );    

[priceA,errorA] = ...
    priceKnockoutByMonteCarloAntithetic( ...
        K, barrier, T, ...
        S0, r, sigma, ...
        nPaths, nSteps );
expected = blackScholesCallPrice( K, T, ...
        S0, r, sigma );

assertApproxEqual( price, expected, 2*error );    

fprintf('Price %d\n', price);
fprintf('Price A %d\n', priceA);
fprintf('Expected %d\n', expected);
fprintf('Error %d\n', error );
fprintf('Error A %d\n', errorA );



end

