function testPriceKnockoutByMonteCarlo()
rng('default'); % ensures same random numbers are generated each time

% If the barrier is very high, this should approximate
% a call option very well
barrier = 1000000;
K = 105;
T = 0.5;
S0 = 100;
r = log(1.05);
sigma = 0.1;
nPaths = 10000;
nSteps = 2;

[price,error] = ...
    priceKnockoutByMonteCarlo( ...
        K, barrier, T, ...
        S0, r, sigma, ...
        nPaths, nSteps );
expected = blackScholesCallPrice( K, T, ...
        S0, r, sigma );
assertApproxEqual( price, expected, 2*error );    

% If the barrier is just above the strike,
% the option should be nearly worthless
barrier = 100.001;
K = 95;
nSteps = 1000;
nPaths = 1000;
[price,~] = ...
    priceKnockoutByMonteCarlo( ...
        K, barrier, T, ...
        S0, r, sigma, ...
        nPaths, nSteps );
assert( price<0.005);    
assert( price>0);

end

