function testPriceDerivativeByMonteCarlo()
%TESTPRICEDERIVATIVEBYMONTECARLO Summary of this function goes here
rng('default'); % ensures same random numbers are generated each time

% The priceDerivativeByMonteCarlo function has been written
% so that it takes a function which computes the payoff. This is
% can then be tested easily with a European call option. This
% also means that we only have to write functions to compute payoffs
% to cope with different derivatives.
K = 105;
T = 0.5;
S0 = 100;
r = log(1.05);
sigma = 0.1;
nPaths = 10000;
nSteps = 2; % We know this is not optimal, but it tests more functionality

function p=callPayoff(priceHistory) 
    finalPrice = priceHistory(:,end);
    p = max(finalPrice-K,0);
end

price = ...
    priceDerivativeByMonteCarlo( ...
        @callPayoff, T, ...
        S0, r, sigma, ...
        nPaths, nSteps );
expected = blackScholesCallPrice( K, T, ...
        S0, r, sigma );
assertApproxEqual( price, expected, 0.03 );

% Pricing an Asian option

function [ payoff ] = asianPayoff( ...
    priceHistory )
    averagePrice = mean( priceHistory, 2 );
    inMoney = averagePrice>K;
    payoff = inMoney .* (averagePrice-K);
end

price = ...
    priceDerivativeByMonteCarlo( ...
        @asianPayoff, T, ...
        S0, r, sigma, ...
        nPaths, nSteps );
    
disp('Price of Asian option');
disp( price );

% Pricing a knock-in option

barrier = 110;
function [ payoff ] = knockInPayoff( ...
    priceHistory )

    knockedIn = max( priceHistory>barrier, [], 2);
    finalPrice = priceHistory(:,end);
    inMoney = finalPrice>K;
    payoff = inMoney .* knockedIn .* (finalPrice-K);    

end

price = ...
    priceDerivativeByMonteCarlo( ...
        @knockInPayoff, T, ...
        S0, r, sigma, ...
        nPaths, nSteps );
    
disp('Price of Knock in option');
disp( price );


end

