function testComputeGammaByMonteCarlo()

K = 105;
T = 0.5;
S0 = 100;
r = log(1.05);
sigma = 0.1;
nPaths = 100000;
nSteps = 2;

function p=callPayoff(priceHistory) 
    finalPrice = priceHistory(:,end);
    p = max(finalPrice-K,0);
end

gamma = ...
    computeGammaByMonteCarlo( ...
        @callPayoff, T, ...
        S0, r, sigma, ...
        nPaths, nSteps );
[~,~,expected] = blackScholesCallPrice( K, T, ...
        S0, r, sigma );
assertApproxEqual( gamma, expected, 0.0005 );    

end
