function testComputeDeltaByMonteCarlo()

% If the barrier is very high, this should approximate
% a call option very well
barrier = 1000000;
K = 105;
T = 0.5;
S0 = 100;
r = log(1.05);
sigma = 0.1;
nPaths = 100000;
nSteps = 2;

[delta] = ...
    computeDeltaByMonteCarlo( ...
        K, barrier, T, ...
        S0, r, sigma, ...
        nPaths, nSteps );
[z,expected] = blackScholesCallPrice( K, T, ...
        S0, r, sigma );
assertApproxEqual( delta, expected, 0.002 );    

end