function [price, errorEstimate]=priceKnockoutByMonteCarloAntithetic(...
    strike, barrier, T,...
    S0, r, sigma, ...
    nPaths, nSteps )

% Generate paths in risk neutral measure (mu=r)
priceHistory = generateBSPathsAntithetic(T,S0,r,sigma,nPaths,nSteps);
payoffs = computeKnockoutPayoff(strike,barrier,priceHistory);
discountedPayoff = exp(-r*T)*payoffs;
price = mean( discountedPayoff );

c = cov( discountedPayoff(1:nPaths,:),discountedPayoff(nPaths+1:end,:));
v1 = c(1,1);
v2 = c(2,2);
covariance = c(1,2);
varZ = (v1 + v2 + 2*covariance)/4;
errorEstimate = sqrt(varZ)/sqrt(nPaths);

end