%payoff function should take a matrix with rows being scenarios
%and columns being price history just like computeKnockoutPayoff
function [ price,errorEstimate ] = priceDerivativeByMonteCarlo( ...
    payoffFunction, T,...
    S0,r,sigma,...
    nPaths,nSteps)

% Generate paths in risk neutral measure (mu=r)
priceHistory = generateBSPaths( T, S0,r,sigma,nPaths,nSteps );
payoffs = payoffFunction( priceHistory );
discountedPayoff = exp(-r*T)*payoffs;
price = mean( discountedPayoff );
errorEstimate = std( discountedPayoff )/sqrt(nPaths);

end

