function plotKnockoutAgainstBarrier()

S0 = 100;
r = 0.01;
strike = 110;
sigma = 0.1;
T = 0.5;

nPaths = 10000;
nSteps = 133;

barriers = 90:150;
prices = zeros(1, length( barriers ));
for i=1:length(barriers)
    rng('default'); % Gives a smooth plot
    barrier = barriers(i);
    prices(i) = priceKnockoutByMonteCarlo( ...
        strike, barrier, T,...
        S0, r, sigma, ...
        nPaths, nSteps );
end

plot( barriers, prices );
title('Knockout price versus barrier');

end

