function plotDerivativeEstimates()
%PLOTDERIVATIVEESTIMATES Summary of this function goes here
%   Detailed explanation goes here

f = @sin;
x = 1;

N = 40;
hValues = zeros(N,1);
derivativeEstimateErrorA = zeros(N,1);
derivativeEstimateErrorB = zeros(N,1);
secondDerivativeEstimateError = zeros(N,1);
for i=1:N
    h = 2^(-i);
    hValues(i)=h;
    derivativeEstimateA = ((f(x+h)-f(x))/h);
    derivativeEstimateB = ((f(x+h)-f(x-h))/(2*h));
    secondDerivativeEstimate = ((f(x+h)-2*f(x)+f(x-h))/(h^2));
    derivativeEstimateErrorA(i) = abs( derivativeEstimateA - cos(x));
    derivativeEstimateErrorB(i) = abs( derivativeEstimateB - cos(x));
    secondDerivativeEstimateError(i) = abs( secondDerivativeEstimate + sin(x));
end    

loglog( hValues, derivativeEstimateErrorA, ...
        hValues, derivativeEstimateErrorB, ...
       hValues, secondDerivativeEstimateError );
title('Error in estimate of derivative against h');
xlabel('h');
ylabel('error');
legend('First derivative - formula A', ...
       'First derivative - formula B', ...
       'Second derivative');

end

