function plotBSPercentiles()
%PLOTBSPERCENTILES Summary of this function goes here
%   Detailed explanation goes here

T = 1.0;
nSteps = 365;
S0 = 100;
mu = 0.05;
sigma = 0.1;

nPaths = 10000;

[paths, times] = generateBSPaths(T,S0,mu,sigma,nPaths,nSteps );
prctiles = prctile( paths, [5,50,95] );
plot( times, prctiles(1,:), ...
      times, prctiles(2,:), ...
      times, prctiles(3,:), ...
      times, paths(1,:));  
title('Percentiles of price paths');
xlabel('Time');
ylabel('Stock price');
legend('5% percentile', 'Median', '95% percentile', 'A price path');
  
end  