% This is a very inefficient version of generateBSPaths
% which uses two for loops. 
function  plotBSPath()
T = 1.0;
nSteps = 365;
S0 = 100;
mu = 0.05;
sigma = 0.1;

dt = T/nSteps;
logS0 = log( S0);
logS = zeros(nSteps,1);
for t=1:nSteps
    eps = randn();
    dlogS = (mu-0.5*sigma^2)*dt + sigma*sqrt(dt)*eps;
    if (t==1)
        lastLogS = logS0;
    else
        lastLogS = logS(t-1);
    end
    logS(t) = lastLogS + dlogS;
end

S = exp( logS );
times = (1:nSteps)*dt;
plot(times,S);

end