% Generate random price paths according to the black scholes model
% from time 0 to time T. There should be nSteps in the path and
% nPaths different paths
function [ S, times ] = generateBSPathsAntithetic( ...
    T, S0, mu, sigma,nPaths, nSteps  )

dt = T/nSteps;
logS0 = log( S0);
W = randn( nPaths, nSteps );
dlogS = (mu-0.5*sigma^2)*dt + sigma*sqrt(dt)*W;
logS = logS0 + cumsum( dlogS, 2);
SA = exp(logS);
dlogS = (mu-0.5*sigma^2)*dt - sigma*sqrt(dt)*W;
logS = logS0 + cumsum( dlogS, 2);
SB = exp(logS);

S = [SA; SB];
times = dt:dt:T;

end