% This is a very inefficient version of generateBSPaths
% which uses two for loops. 
function [ S, times ] = generateBSPaths2Loops( ...
    T, S0, mu, sigma, nPaths, nSteps  )

dt = T/nSteps;
logS0 = log( S0);
logS = zeros(nPaths,nSteps);
for p=1:nPaths
    for t=1:nSteps
        eps = randn();
        dlogS = (mu-0.5*sigma^2)*dt + sigma*sqrt(dt)*eps;
        if (t==1)
            lastLogS = logS0;
        else
            lastLogS = logS(p,t-1);
        end
        logS(p,t) = lastLogS + dlogS;
    end
end    
S = exp(logS);
times = dt:dt:T;
end

