% This is a reasonably efficient version
% of generateBSPaths that uses vectorization across
% scenarios
function [ S, times ] = generateBSPaths1Loop( ...
    T, S0, mu, sigma, nPaths, nSteps )

dt = T/nSteps;
logS0 = log( S0);
eps = randn(nPaths, nSteps);
dlogS = (mu-0.5*sigma^2)*dt + sigma*sqrt(dt)*eps;
logS = zeros(nPaths,nSteps);
for t=1:nSteps
    if (t==1)
        lastLogS = logS0;
    else
        lastLogS = logS(:,t-1);
    end
    logS(:,t) = lastLogS + dlogS(:,t);
end
S = exp(logS);
times = dt:dt:T;
end

