% A very inefficient version of computeKnockoutPayoff
% which uses 2 loops
function [ payoff ] = computeKnockoutPayoff2Loops(...
    strike, barrier, priceHistory )

nPaths = size( priceHistory, 1 );
nSteps = size( priceHistory, 2 );
payoff = zeros( nPaths, 1 );
for p=1:nPaths;
    knockedOut = 0;
    for t=1:nSteps
        if priceHistory(p,t)>barrier
            knockedOut = 1;
        end
    end
    if (~knockedOut) 
        finalPrice = priceHistory( p, nSteps );
        if (finalPrice>strike) 
            payoff(p)=finalPrice-strike;
        end
    end
end    
end



