% A slightly inefficient version of computeKnockoutPayoff
% which uses a loop
function [ payoff ] = computeKnockoutPayoff1Loop( ...
    strike, barrier, priceHistory )

nPaths = size( priceHistory, 1 );
nSteps = size( priceHistory, 2 );

knockedOut = zeros( nPaths, 1);
for t=1:nSteps
    knockedOutThisTime = (priceHistory(:,t) > barrier);
    knockedOut = knockedOut | knockedOutThisTime;
end
finalPrice = priceHistory( :, nSteps );
inMoney = finalPrice>strike;
payoff=(~knockedOut).*inMoney.*(finalPrice-strike);
end

