%COMPUTEKNOCKOUTPAYOFF
% Computes the payoff of a knockout
% option given the priceHistory. priceHistory
% should have rows corresponding to scenarios
% and columns corresponding to times
function [ payoff ] = computeKnockoutPayoff( ...
    strike, barrier, priceHistory )

knockedOut = max( priceHistory>barrier, [], 2);
notKnockedOut = 1-knockedOut;
finalPrice = priceHistory(:,end);
inMoney = finalPrice>strike;
payoff = inMoney .* notKnockedOut .* (finalPrice-strike);

end

