function [ gamma ] = computeGammaByMonteCarlo( ...
    payoffFunction, T,...
    S0, r, sigma, ...
    nPaths, nSteps )

h = 10^(-3)*S0; % More conservative choice than for delta

rng('default');
pm1 = priceDerivativeByMonteCarlo(payoffFunction,T,...
    S0-h, r, sigma, ...
    nPaths, nSteps );
rng('default');
p0 = priceDerivativeByMonteCarlo(payoffFunction,T,...
    S0, r, sigma, ...
    nPaths, nSteps );
rng('default');
pp1 = priceDerivativeByMonteCarlo(payoffFunction,T,...
    S0+h, r, sigma, ...
    nPaths, nSteps );
gamma = (pm1-2*p0+pp1)/(h^2);

end



