function [ delta ] = computeDeltaByMonteCarlo2( ...
    payoffFunction, ...
    T,...
    S0, r, sigma, ...
    nPaths, nSteps )
% This code improves on computeDeltaByMonteCarlo
% in that it doesn't always use exactly the same random numbers.
% We generate one set of black scholes paths at the beginning
% and then rescale these paths to reflect the starting stock price.
% This gives us two prices, one corresponding to a starting stock price
% of S0-h, one corresponding to S0+h. We can then compute the delta.

h = 10^(-6)*S0; % Won't cause rounding problems
                % but a minute change financially

priceHistory = generateBSPaths( T, S0,r,sigma,nPaths,nSteps );
startingStockPrices = [S0-h,S0+h];
prices = [0 0];
for i=1:2
    s = startingStockPrices(i);
    modifiedPriceHistory = priceHistory*s/S0;
    payoffs = payoffFunction( modifiedPriceHistory );
    discountedPayoff = exp(-r*T)*payoffs;
    prices(i) = mean( discountedPayoff );
end                
delta = (prices(2)-prices(1))/(2*h);

end