function [ delta ] = computeDeltaByMonteCarlo( ...
    strike, barrier, T,...
    S0, r, sigma, ...
    nPaths, nSteps )

h = 10^(-6)*S0; % Won't cause rounding problems
                % but a minute change financially

rng('default');
p1 = priceKnockoutByMonteCarlo(strike,barrier,T,...
    S0-h, r, sigma, ...
    nPaths, nSteps );
rng('default');
p2 = priceKnockoutByMonteCarlo(strike,barrier,T,...
    S0+h, r, sigma, ...
    nPaths, nSteps );
delta = (p2-p1)/(2*h);

end

