function [ price, delta, gamma ] = blackScholesCallPrice( K, T, S0, r, sigma )
% Computes the price of an option using the Black Scholes formula.
% (The parameter order is contract terms then market data.)

numerator = log(S0./K) + (r+0.5*sigma.^2).*T;
denominator = sigma.*sqrt(T);
d1 = numerator./denominator;
d2 = d1 - denominator;
price = S0 .* normcdf(d1) - exp(-r.*T).*K.*normcdf(d2);
delta = normcdf(d1);
gamma = normpdf(d1) ./ (S0.*denominator);

end

