function testPriceDerivativeByIntegration()
%TESTPRICEDERIVATIVEBYINTEGRATION Check the general
% price derivative function.

% It would be fine for students to just copy and paste
% priceCallByIntegration and write versions called
% pricePutByIntegration etc.  This version is a little
% neater

K = 105;
r = log(1.05);
S0 = 100;
sigma = 0.1;
T = 0.25;

function p = callPayoff( S )
    p = max( S-K, 0);
end

function p = putPayoff( S )
    p = max( K-S, 0);
end

function p = digitalCallPayoff( S )
    p = S>K;
end

function p = digitalPutPayoff( S )
    p = S<K;
end

% Test my priceDerivative by integration function
callPrice = priceDerivativeByIntegration(@callPayoff,T, S0, r, sigma,10001 );
expected = priceCallByIntegration(K,T, S0, r, sigma );
assertApproxEqual( callPrice, expected, 0.001 );

% Price the different types of derivative
putPrice = priceDerivativeByIntegration(@putPayoff,T, S0, r, sigma,10001 );
digitalCallPrice = priceDerivativeByIntegration(@digitalCallPayoff,T, S0, r, sigma,10001 );
digitalPutPrice = priceDerivativeByIntegration(@digitalPutPayoff,T, S0, r, sigma,10001 );

fprintf('Call price %d\n',callPrice);
fprintf('Put price %d\n',putPrice);
fprintf('Digital call price %d\n',digitalCallPrice);
fprintf('Digital put price %d\n',digitalPutPrice);
% We check put call parity for digitals
assertApproxEqual( digitalCallPrice+digitalPutPrice, 1.0, 0.015 ); %Not very accurate!


end

