function testPriceCallByIntegration()
% A call option with strike 0 is the same thing
% as buying the stock. Check we get the correct answer.
% This is effectively a test that our pricing
% kernel is risk neutral
r = log(1.05);
S0 = 100;
sigma = 0.1;
T = 0.25;
actual = priceCallByIntegration(0,T, S0, r, sigma );
assertApproxEqual( actual, S0, 0.001 );
end

