function testPriceByIntegrationUsingQ()

% I've used function passing to write a single function
% priceByIntegrationUsingQ that allows me to choose the integration
% rule and the option. I'd be happy with an answer that used more
% cut and paste, but its nice to see how to do things with less code

K = 105;
r = log(1.05);
S0 = 100;
sigma = 0.1;
T = 0.25;

function p = callPayoff( S )
    p = max( S-K, 0);
end

expected = blackScholesCallPrice( K,T, S0,r,sigma);
rectanglePrice = priceByIntegrationUsingQ( @integrateByRectangleRule, @callPayoff, T, S0, r, sigma, 10001);
assertApproxEqual( expected, rectanglePrice, 0.001);

monteCarloPrice = priceByIntegrationUsingQ( @integrateByMonteCarlo, @callPayoff, T, S0, r, sigma, 10001);

fprintf('Price using rectangle rule %d\n',rectanglePrice);
fprintf('Price using monte carlo %d\n',monteCarloPrice);
fprintf('Actual price %d\n',expected);


end

