function testComputeDeltaByIntegration()

K = 105;
r = log(1.05);
S0 = 100;
sigma = 0.1;
T = 0.25;

function p = callPayoff( S )
    p = max( S-K, 0);
end

actual = computeDeltaByIntegration(@callPayoff,T,S0,r,sigma,100001);
% Note that my blackScholesCallPrice function
% returns both the price and the delta
[~,expected] = blackScholesCallPrice(K,T,S0,r,sigma);
assertApproxEqual( actual, expected, 0.0001 );

end
